% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{sdf_sort}
\alias{sdf_sort}
\title{Sort a Spark DataFrame}
\usage{
sdf_sort(x, columns)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame.}

\item{columns}{The column(s) to sort by.}
}
\description{
Sort a Spark DataFrame by one or more columns, with each column
sorted in ascending order.
}
\section{Transforming Spark DataFrames}{


The family of functions prefixed with \code{sdf_} generally access the Scala
Spark DataFrame API directly, as opposed to the \code{dplyr} interface which
uses Spark SQL. These functions will 'force' any pending SQL in a
\code{dplyr} pipeline, such that the resulting \code{tbl_spark} object
returned will no longer have the attached 'lazy' SQL operations. Note that
the underlying Spark DataFrame \emph{does} execute its operations lazily, so
that even though the pending set of operations (currently) are not exposed at
the \R level, these operations will only be executed when you explicitly
\code{collect()} the table.
}

\seealso{
Other Spark data frames: \code{\link{sdf_copy_to}},
  \code{\link{sdf_partition}}, \code{\link{sdf_predict}},
  \code{\link{sdf_register}}, \code{\link{sdf_sample}}
}
\concept{Spark data frames}
