/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sparklyr.BackendHandler;
import sparklyr.Logger;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u000b\tq!)Y2lK:$7\t[1o]\u0016d'\"A\u0002\u0002\u0011M\u0004\u0018M]6msJ\u001c\u0001a\u0005\u0002\u0001\rA\u0011qAC\u0007\u0002\u0011)\t\u0011\"A\u0003tG\u0006d\u0017-\u0003\u0002\f\u0011\t1\u0011I\\=SK\u001aD\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u0001\u0007Y><w-\u001a:\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!A\u0002'pO\u001e,'\u000fC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0003+Y\u0001\"a\u0004\u0001\t\u000b5\u0011\u0002\u0019\u0001\b\t\ra\u0001\u0001\u0015)\u0003\u001a\u00035\u0019\u0007.\u00198oK24U\u000f^;sKB\u0011!$I\u0007\u00027)\u0011A$H\u0001\bG\"\fgN\\3m\u0015\tqr$A\u0003oKR$\u0018PC\u0001!\u0003\tIw.\u0003\u0002#7\ti1\t[1o]\u0016dg)\u001e;ve\u0016Da\u0001\n\u0001!B\u0013)\u0013!\u00032p_R\u001cHO]1q!\t1\u0003&D\u0001(\u0015\t!S$\u0003\u0002*O\ty1+\u001a:wKJ\u0014un\u001c;tiJ\f\u0007\u000f\u0003\u0004,\u0001\u0001\u0006K\u0001L\u0001\nE>\u001c8o\u0012:pkB\u0004\"AG\u0017\n\u00059Z\"AD#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0005\u0007a\u0001\u0001\u000b\u0015B\u0019\u0002\u0017%tW\r^!eIJ,7o\u001d\t\u0003e]j\u0011a\r\u0006\u0003iU\n1A\\3u\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000f\u0003\u0004;\u0001\u0001\u0006KaO\u0001\fQ>\u001cHoQ8oi\u0016DH\u000f\u0005\u0002=\u007f9\u0011q!P\u0005\u0003}!\ta\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011a\b\u0003\u0005\u0006\u0007\u0002!\t\u0001R\u0001\u000fg\u0016$\bj\\:u\u0007>tG/\u001a=u)\t)\u0005\n\u0005\u0002\b\r&\u0011q\t\u0003\u0002\u0005+:LG\u000fC\u0003J\u0005\u0002\u00071(\u0001\ti_N$8i\u001c8uKb$\b+\u0019:b[\")1\n\u0001C\u0001\u0019\u0006!\u0011N\\5u)\ti\u0005\u000b\u0005\u0002\b\u001d&\u0011q\n\u0003\u0002\u0004\u0013:$\b\"B)K\u0001\u0004\u0011\u0016A\u0002:f[>$X\r\u0005\u0002\b'&\u0011A\u000b\u0003\u0002\b\u0005>|G.Z1o\u0011\u00151\u0006\u0001\"\u0001X\u0003\r\u0011XO\u001c\u000b\u0002\u000b\")\u0011\f\u0001C\u0001/\u0006)1\r\\8tK\u0002")
public class BackendChannel {
    private final Logger logger;
    private ChannelFuture channelFuture;
    private ServerBootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private InetSocketAddress inetAddress;
    private String hostContext;

    public void setHostContext(String hostContextParam) {
        this.hostContext = hostContextParam;
    }

    public int init(boolean remote) {
        if (remote) {
            byte[] anyIpAddress = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
            InetAddress anyInetAddress = InetAddress.getByAddress(anyIpAddress);
            this.inetAddress = new InetSocketAddress(anyInetAddress, 0);
        } else {
            this.inetAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        SparkConf conf = new SparkConf();
        EventLoopGroup workerGroup = this.bossGroup = new NioEventLoopGroup(conf.getInt("sparklyr.backend.threads", 10));
        BackendHandler handler = new BackendHandler(this, this.logger, this.hostContext);
        this.bootstrap = (ServerBootstrap)new ServerBootstrap().group(this.bossGroup, workerGroup).channel(NioServerSocketChannel.class);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, handler){
            private final BackendHandler handler$1;

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast("encoder", (ChannelHandler)new ByteArrayEncoder()).addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)).addLast("decoder", (ChannelHandler)new ByteArrayDecoder()).addLast("handler", (ChannelHandler)this.handler$1);
            }
            {
                this.handler$1 = handler$1;
            }
        });
        this.channelFuture = this.bootstrap.bind((SocketAddress)this.inetAddress);
        this.channelFuture.syncUninterruptibly();
        return ((InetSocketAddress)this.channelFuture.channel().localAddress()).getPort();
    }

    public void run() {
        this.channelFuture.channel().closeFuture().syncUninterruptibly();
    }

    public void close() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        Object object = this.bootstrap == null || this.bootstrap.group() == null ? BoxedUnit.UNIT : this.bootstrap.group().shutdownGracefully();
        Object object2 = this.bootstrap == null || this.bootstrap.childGroup() == null ? BoxedUnit.UNIT : this.bootstrap.childGroup().shutdownGracefully();
        this.bootstrap = null;
    }

    public BackendChannel(Logger logger) {
        this.logger = logger;
        this.channelFuture = null;
        this.bootstrap = null;
        this.bossGroup = null;
        this.inetAddress = null;
        this.hostContext = null;
    }
}

