% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{sdf_copy_to}
\alias{sdf_copy_to}
\alias{sdf_import}
\title{Copy an Object into Spark}
\usage{
sdf_copy_to(sc, x, ...)

sdf_import(x, sc, ...)
}
\arguments{
\item{sc}{The associated Spark connection.}

\item{x}{An \R object from which a Spark DataFrame can be generated.}

\item{...}{Optional arguments, passed to implementing methods.}
}
\description{
Copy an object into Spark, and return an \R object wrapping the
copied object (typically, a Spark DataFrame).
}
\section{Advanced Usage}{


\code{sdf_copy_to} is an S3 generic that, by default, dispatches to
\code{sdf_import}. Package authors that would like to implement
\code{sdf_copy_to} for a custom object type can accomplish this by
implementing the associated method on \code{sdf_import}.
}
\seealso{
Other Spark data frames: \code{\link{sdf_partition}},
  \code{\link{sdf_predict}}, \code{\link{sdf_register}},
  \code{\link{sdf_sample}}, \code{\link{sdf_sort}}
}

