% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{apply_axes}
\alias{apply_axes}
\title{Apply a function over specified array axes.}
\usage{
apply_axes(x, axes, fun, ...)
}
\arguments{
\item{x}{an array.}

\item{axes}{a vector of axes to apply fun over.}

\item{fun}{function to be applied.}

\item{...}{optional arguments to fun.}
}
\value{
array.
}
\description{
Apply a function over specified array axes.
}
\examples{
z <- array(1:1000, dim = c(10, 10, 10))
a <- apply_axes(z, 3, fft)
a[1,1,] == fft(z[1,1,])
a <- apply_axes(z, 3, sum)
a[1,1,] == sum(z[1,1,])
}
