#' spacejamr: A package for simulating spatial Bernoulli networks
#'
#' @description The spacejamr package provides three main types of functions:
#' spacejamr, PointSim, and NetSim. They create new objects used in subsequent
#' steps of network simulation, simulate spatial point processes, and create
#' network objects. There are also plot, print, and summary methods for all
#' objects and a compare_networks function to quickly compare two simulated
#' networks.
#'
#' @section Functions:
#' APLNetwork \cr
#' compare_networks \cr
#' HaltonSeq \cr
#' RI \cr
#' plot.NetSim \cr
#' plot.PointSim \cr
#' plot.spacejamr \cr
#' PointProcess \cr
#' PowerLawNetwork \cr
#' print.NetSim \cr
#' print.PointSim \cr
#' print.spacejamr \cr
#' spacejamr \cr
#' summary.NetSim \cr
#' summary.spacejamr \cr
#' summary.PointSim \cr
#'
#' @author Darren Colby \cr
#' Email: dscolby17@@gmail.com \cr
#' ORCID: 0000-0001-8468-2755
#'
#' @docType package
#' @name spacejamr
NULL
