% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LuTest.R
\name{LuTest}
\alias{LuTest}
\title{Nonparametric Test of Symmetry Using the Periodogram}
\usage{
LuTest(spdata, nrows, ncols, test = "complete", nsim = 5000)
}
\arguments{
\item{spdata}{An \eqn{n} by \eqn{3} matrix. The first two columns provide \eqn{(x,y)} spatial coordinates. The third column provides data values at the coordinates.}

\item{nrows}{The number of rows of observed data.}

\item{ncols}{The number of columns of observed data.}

\item{test}{A string taking the value "reflection" or "complete" for a test of reflection or complete symmetry. If 'test' = "complete", a test for complete symmetry is performed after a test of reflection symmetry is performed and both p-values are returned.}

\item{nsim}{The number simulations used to approximate the sampling distribution of CvM and CvM* from Lu ad Zimmerman (2005).}
}
\value{
\item{pvalue.refl}{The p-value for the test of reflection symmetry computed by the CvM GoF test.}
 \item{pvalue.comp}{If 'test' = "complete", the p-value for the test of complete symmetry computed by using the CvM* GoF test.}
}
\description{
This function performs the nonparametric tests of reflection and complete symmetry from Lu and Zimmerman (2005) for spatial data with sampling locations on the integer grid. See Lu and Zimmerman (2005) for more details.
}
\details{
The function assumes data are on the integer grid, \eqn{Z^2}. It uses the (unsmoothed) periodogram, the Fourier transform of the sample covariance function, to test symmetry properties.
}
\examples{
library(mvtnorm)
set.seed(1)
#Number of rows and columns
nr <- 18
nc <- 12
n <- nr*nc
#Set up the coordinates
coords <- expand.grid(0:(nr-1), 0:(nc-1))
coords <- cbind(coords[,2], coords[,1])
#Compute the distance between sampling locations
D <- as.matrix(dist(coords))
#Set parameter values for exponential covariance function
sigma.sq <- 1
tau.sq <- 0.0
phi <- 1/4
#Simulate data using isotropic covariance function
D <- as.matrix(dist(coords))
R <- sigma.sq * exp(-phi*D)
R <- R + diag(tau.sq, nrow = n, ncol = n)
z <- rmvnorm(1,rep(0,n), R, method = c("chol"))
z <-  z-mean(z)
z <- t(z)
mydata <- cbind(coords, z)
#Run the test on the data from an isotropic covariance function
tr <- LuTest(mydata, nr, nc, test = "complete", nsim = 1000)
tr

#Simulate data from anisotropic covariance function
aniso.angle <- pi/4
aniso.ratio <- 2
coordsA <- coords.aniso(coords, c(aniso.angle, aniso.ratio))
Da <- as.matrix(dist(coordsA))
R <- sigma.sq * exp(-phi*Da)
R <- R + diag(tau.sq, nrow = n, ncol = n)
z <- rmvnorm(1,rep(0,n), R, method = c("chol"))
z <-  z-mean(z)
z <- t(z)
mydata <- cbind(coords, z)
#Run the test on the data generated from an anisotropic
#(and non reflection and non completely symmetric) covariance function
tr <- LuTest(mydata, nr, nc, test = "complete", nsim = 1000)
tr
}
\references{
Lu, N., & Zimmerman, D. L. (2005). Testing for directional symmetry in spatial dependence using the periodogram. \emph{Journal of Statistical Planning and Inference}, 129(1), 369-385.
}
\seealso{
\code{\link{GuanTestGrid}}
}
\keyword{external}

