% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spDates.R
\name{modelDates}
\alias{modelDates}
\title{Perform regression of archaeological dates on great circle distances from
a hypothetical origin. Dates can be filtered to retain only the earliest
dates per distance bins (Hamilton and Buchanan 2007). Bootstrap is executed
to account for uncertainty in calibrated dates. If a cost surface is
provided, distances are calculated using least cost paths instead of great
circle distances. Regression can be either reduced major axis or ordinary
least squares. If using ordinary least squares, regression is performed
both on time-versus-distance and on distance-versus-time.}
\usage{
modelDates(
  ftrSites,
  c14bp,
  origin,
  binWidth = 0,
  nsim = 999,
  cost = NULL,
  method = "rma",
  ncores = 1
)
}
\arguments{
\item{ftrSites}{A SpatialPointsDataFrame object with associated earliest
C14 dates per site and respective calibrated distributions (CalDates
objects) in a field named "cal". Result of applying filterDates() and
calAll().}

\item{c14bp}{A string. Name of the field with the radiocarbon ages in C14
BP format.}

\item{origin}{A SpatialPointsDataFrame object. The site considered as
hypothetical origin of expansion.}

\item{binWidth}{A number. Width of the spatial bins in km, calculated as
distance intervals from the hypothetical origin. Default is 0 (no bins).}

\item{nsim}{A number. Number of simulations to be run during the
bootstrapping procedure. Default is 999.}

\item{cost}{Optional. A RasterLayer with friction values to calculate
least cost path distances instead of great circle distances.}

\item{method}{A string. Method to be used in the regression. One of "rma"
or "ols". Default is "rma".}

\item{ncores}{A number. Number of cores used for parallel processing.
Default is 1.}
}
\value{
a dateModel object.
}
\description{
Perform regression of archaeological dates on great circle distances from
a hypothetical origin. Dates can be filtered to retain only the earliest
dates per distance bins (Hamilton and Buchanan 2007). Bootstrap is executed
to account for uncertainty in calibrated dates. If a cost surface is
provided, distances are calculated using least cost paths instead of great
circle distances. Regression can be either reduced major axis or ordinary
least squares. If using ordinary least squares, regression is performed
both on time-versus-distance and on distance-versus-time.
}
\examples{
\donttest{
data(neof)
data(centers)
jericho <- centers[centers$Site=="Jericho",]
model <- modelDates(neof, "C14Age", jericho, method="ols")
}
\dontshow{
data(neof)
data(centers)
jericho <- centers[centers$Site=="Jericho",]
model <- modelDates(neof[1:2,], "C14Age", jericho, method="ols",
nsim=1, ncores=2)
}
}
