% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_wrappers.R
\name{FEVD}
\alias{FEVD}
\title{Estimate forecast error variance decomposition}
\usage{
FEVD(model, horizon = 10, scale = TRUE)
}
\arguments{
\item{model}{VAR or RVAR class object}

\item{horizon}{int: number of periods}

\item{scale}{boolean: scale variable contribution as percent of total error}
}
\value{
long-form data.frame
}
\description{
Estimate the forecast error variance decomposition for VARs with
either short or 'IV-short' structural errors. See VAR
and RVAR documentation for details regarding structural errors.
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)

 # estimate VAR
  var =
    sovereign::VAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      lag.ic = 'BIC',
      lag.max = 4)

# impulse response functions
var.irf = sovereign::IRF(var)

# forecast error variance decomposition
var.fevd = sovereign::FEVD(var)

# historical shock decomposition
var.hd = sovereign::HD(var)

}

}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_fevd]{var_fevd()}}

\code{\link[=RVAR]{RVAR()}}

\code{\link[=rvar_fevd]{rvar_fevd()}}
}
