% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_irf.R
\name{var_irf}
\alias{var_irf}
\title{Estimate impulse response functions}
\usage{
var_irf(var, horizon = 10, bootstraps.num = 100, CI = c(0.1, 0.9))
}
\arguments{
\item{var}{VAR output}

\item{horizon}{int: number of periods}

\item{bootstraps.num}{int: number of bootstraps}

\item{CI}{numeric vector: c(lower ci bound, upper ci bound)}
}
\value{
list object with elements \code{irfs}, \code{ci.lower}, and \code{ci.upper}; all elements are long-form data.frames
}
\description{
Estimate impulse responses with contemporaneous impact restrictions via Cholesky decomposition -
taking the variable ordering present in the VAR object.
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)

 # estimate VAR
  var =
    sovereign::VAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      lag.ic = 'BIC',
      lag.max = 4)

# impulse response functions
var.irf = sovereign::var_irf(var)

# forecast error variance decomposition
var.fevd = sovereign::var_fevd(var)

# historical shock decomposition
var.hd = sovereign::var_hd(var)

}

}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_irf]{var_irf()}}

\code{\link[=var_fevd]{var_fevd()}}

\code{\link[=var_hd]{var_hd()}}

\code{\link[=RVAR]{RVAR()}}

\code{\link[=rvar_irf]{rvar_irf()}}

\code{\link[=rvar_fevd]{rvar_fevd()}}

\code{\link[=rvar_hd]{rvar_hd()}}
}
