% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{RVAR}
\alias{RVAR}
\title{Estimate regime-dependent VAR}
\usage{
RVAR(
  data,
  horizon = 10,
  freq = "month",
  type = "const",
  p = 1,
  lag.ic = NULL,
  lag.max = NULL,
  regime = NULL,
  regime.method = "rf",
  regime.n = 2
)
}
\arguments{
\item{data}{data.frame, matrix, ts, xts, zoo: Endogenous regressors}

\item{horizon}{int: forecast horizons}

\item{freq}{string: frequency of data ('day', 'week', 'month', 'quarter', or 'year')}

\item{type}{string: type of deterministic terms to add ('none', 'const', 'trend', or 'both')}

\item{p}{int: lags}

\item{lag.ic}{string: information criterion to choose the optimal number of lags ('AIC' or 'BIC')}

\item{lag.max}{int: maximum number of lags to test in lag selection}

\item{regime}{string: name or regime assignment vector in the design matrix (data)}

\item{regime.method}{string: regime assignment technique ('rf', 'kmeans', 'EM', or 'BP')}

\item{regime.n}{int: number of regimes to estimate (applies to kmeans and EM)}
}
\value{
list of lists, each regime returns its own list with elements \code{data}, \code{model}, \code{forecasts}, \code{residuals}
}
\description{
Estimate a regime-dependent VAR (i.e. a state-dependent VAR), with an exogenous state indicator, of the specification:
\deqn{Y_t = X \beta_s + \epsilon_t}
where t is the time index, Y is the set of outcome vectors, X the design matrix (of p lagged values of Y), and
s is a mutually exclusive state of the world observed at time t-1. When the regime vector is not supplied by the user, then a two-state
regime series is estimated via random forest.
}
\details{
The regime-dependent VAR is a generalization of the popular threshold VAR - which trades off estimating a threshold value for an
endogenous variable for accepting an exogenous regime that can be based on information from inside or outside of the system, with or without parametric
assumptions, and with or without timing restrictions.
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)
 Data = dplyr::mutate(Data, reg = dplyr::if_else(AA > median(AA), 1, 0))

 # estimate regime-dependent VAR
  rvar =
    sovereign::RVAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      regime.method = 'rf',
      regime.n = 2,
      lag.ic = 'BIC',
      lag.max = 4)

# impulse response functions
rvar.irf = sovereign::rvar_irf(rvar)

# forecast error variance decomposition
rvar.fevd = sovereign::rvar_fevd(rvar)

# historical shock decomposition
rvar.hd = sovereign::rvar_hd(rvar)

}

}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_irf]{var_irf()}}

\code{\link[=var_fevd]{var_fevd()}}

\code{\link[=var_hd]{var_hd()}}

\code{\link[=RVAR]{RVAR()}}

\code{\link[=rvar_irf]{rvar_irf()}}

\code{\link[=rvar_fevd]{rvar_fevd()}}

\code{\link[=rvar_hd]{rvar_hd()}}
}
