% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{.reverb}
\alias{.reverb}
\title{Add reverb to a sound}
\usage{
.reverb(
  audio,
  echoDelay = 200,
  echoLevel = -20,
  reverbDelay = 70,
  reverbSpread = 130,
  reverbLevel = -25,
  reverbDensity = 50,
  reverbType = "gaussian",
  filter = list(),
  dynamicRange = 80,
  output = c("audio", "detailed")[1],
  play = FALSE
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{echoDelay}{the delay at which the echo appears, ms}

\item{echoLevel}{the rate at which the echo weakens at each repetition, dB}

\item{reverbDelay}{the time of maximum reverb density, ms}

\item{reverbSpread}{standard deviation of reverb spread around time
\code{reverbDelay}, ms}

\item{reverbLevel}{the maximum amplitude of reverb, dB below input}

\item{reverbDensity}{the number of echos or "voices" added}

\item{reverbType}{so far only "gaussian" has been implemented}

\item{filter}{(optional) a spectral filter to apply to the created reverb and
echo (see \code{addFormants} for acceptable formats)}

\item{dynamicRange}{the precision with which the reverb and echo are
calculated, dB}

\item{output}{"audio" = returns just the processed audio, "detailed" =
returns a list with reverb window, the added reverb/echo, etc.}

\item{play}{if TRUE, plays the processed audio}
}
\description{
Internal soundgen function, see \code{\link{reverb}}.
}
\keyword{internal}
