% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtl.R
\name{getFormantDispersion}
\alias{getFormantDispersion}
\title{Get formant dispersion}
\usage{
getFormantDispersion(
  formants,
  method = c("meanDispersion", "regression")[2],
  interceptZero = TRUE,
  speedSound = 35400,
  plot = FALSE,
  checkFormat = TRUE,
  output = c("simple", "detailed")[1]
)
}
\arguments{
\item{formants}{formant frequencies in any format recognized by
\code{\link{soundgen}}: a character string like \code{aaui} referring to
default presets for speaker "M1"; a vector of formant frequencies like
\code{c(550, 1600, 3200)}; or a list with multiple values per formant like
\code{list(f1 = c(500, 550), f2 = 1200))}}

\item{method}{the method of estimating vocal tract length (see details)}

\item{interceptZero}{if TRUE, forces the regression curve to pass through the
origin, which corresponds to a closed-open tube (method = "regression" only)}

\item{speedSound}{speed of sound in warm air, by default 35400 cm/s. Stevens
(2000) "Acoustic phonetics", p. 138}

\item{plot}{if TRUE, plots the regression line whose slope gives formant
dispersion (method = "regression" only) and Label size shows the influence
of each observation; the second plot shows how VTL varies depending on the
number of formants used}

\item{checkFormat}{if FALSE, only a list of properly formatted formant
frequencies is accepted}

\item{output}{"simple" (default) = just the VTL; "detailed" = a list of
additional stats (see Value below)}
}
\description{
Internal soundgen function.
}
\details{
Estimates formant dispersion based on one or more formant frequencies.
}
\examples{
soundgen:::getFormantDispersion(
  list(f1 = c(570, 750), f2 = NA, f3 = c(2400, 2200, NA)))
}
\keyword{internal}
