% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loudness.R
\name{getLoudnessFolder}
\alias{getLoudnessFolder}
\title{Loudness per folder}
\usage{
getLoudnessFolder(myfolder, windowLength = 50, step = NULL,
  overlap = 50, SPL_measured = 70, Pref = 2e-05,
  spreadSpectrum = TRUE, summary = TRUE, summaryFun = "mean",
  verbose = TRUE)
}
\arguments{
\item{myfolder}{path to folder containing wav/mp3 files}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{SPL_measured}{sound pressure level at which the sound is presented, dB}

\item{Pref}{reference pressure, Pa}

\item{spreadSpectrum}{if TRUE, applies a spreading function to account for
frequency masking}

\item{summary}{if TRUE, returns only a single value of loudness per file}

\item{summaryFun}{the function used to summarize loudness values across all STFT frames (if
\code{summary = TRUE})}

\item{verbose}{if TRUE, reports estimated time left}
}
\description{
A wrapper around \code{\link{getLoudness}} that goes through all wav/mp3 files in
a folder and returns either a list with loudness values per STFT frame from each file
or, if \code{summary = TRUE}, a dataframe with a single summary value of loudness
per file. This summary value can be mean, max and so on, as per
\code{summaryFun}.
}
\examples{
\dontrun{
getLoudnessFolder('~/Downloads/temp')
# Compare:
analyzeFolder('~/Downloads/temp', pitchMethods = NULL,
              plot = FALSE)$loudness_mean
# (per STFT frame; should be very similar, but not identical, because
# analyze() discards frames considered silent or too noisy)

getLoudnessFolder('~/Downloads/temp', summaryFun = function(x) diff(range(x)))

# save loudness values per frame without summarizing
l = getLoudnessFolder('~/Downloads/temp', summary = FALSE)
}
}
