% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{findPairs}
\alias{findPairs}
\title{A convenience wrapper around \code{\link{findExamples}}.}
\usage{
findPairs(data, x, y, exact, cols)
}
\arguments{
\item{data}{[soundcorrs] The dataset in which to look. Only datasets with two languages are supported.}

\item{x}{[character] The sequence to find in language1. May be a regular expression. If an empty string, anything will be considered a match.}

\item{y}{[character] The sequence to find in language2. May be a regular expression. If an empty string, anything will be considered a match.}

\item{exact}{[numeric] If 0 or \code{FALSE}, \code{distance.start}=\code{distance.end}=-1, \code{na.value}=0, and \code{zeros}=\code{FALSE}. If 0.5, \code{distance.start}=\code{distance.end}=1, \code{na.value}=0, and \code{zeros}=\code{FALSE}. If 1 or \code{TRUE}, \code{distance.start}=\code{distance.end}=0, \code{na.value}=-1, and \code{zeros}=\code{TRUE}. Defaults to 0.}

\item{cols}{[character vector] Which columns of the dataset to return as the result. Can be a vector of names, \code{"aligned"} (the two columns with segmented, aligned words), or \code{"all"} (all columns). Defaults to \code{"aligned"}.}
}
\value{
[df.findExamples] A subset of the dataset, containing only the pairs with corresponding sequences. Warning: pairs with multiple occurrences of such sequences are only included once.
}
\description{
Sift the dataset for word pairs such that the first word contains \code{x} and the second word contains \code{y} in the corresponding segment or segments.
}
\details{
Probably the most common usage of \code{\link{findExamples}} is with datasets containing pairs of words. This function is a simple wrapper around \code{\link{findExamples}} which hopes to facilitate its use in this most common case. Instead of the five arguments that \code{\link{findExamples}} requires, this function only takes two. It is, of course, at the cost of control but should a more fine-tuned search be required, \code{\link{findExamples}} can always still be used instead of \code{findPairs}.
}
\examples{
# In the examples below, non-ASCII characters had to be escaped for technical reasons.
# In the actual usage, Unicode is supported under BSD, Linux, and macOS.

# prepare sample dataset
dataset <- loadSampleDataset ("data-ie")
# run findPairs
findPairs (dataset, "a", "a")
findPairs (dataset, "e", "f", exact=0)
findPairs (dataset, "e", "f", exact=0.5)
findPairs (dataset, "e", "f", exact=1)
}
\seealso{
\code{\link{findExamples}}, \code{\link{allPairs}}
}
