% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{fitTable}
\alias{fitTable}
\title{Fit multiple models to multiple datasets.}
\usage{
fitTable(models, data, margin, conv = vec2df.id, ...)
}
\arguments{
\item{models}{[list] A list of models to fit \code{data} to. Each element must be a list with at least two named fields: \code{formula} which contains the formula, and \code{start} which is a list of lists of starting estimates. Regarding the formula, the converter functions (\code{fun}, below) use "X" and "Y" for column names.}

\item{data}{[matrix/table] The data to fit \code{models} to.}

\item{margin}{[integer] As in \code{\link{apply}}: the subscripts which the fitting function (cf. \code{\link{multiFit}}) will be applied over. Accepted values are: \code{1} for rows, and \code{2} for columns.}

\item{conv}{[function] Function that converts vectors into data frames to which \code{models} will be fitted. Available functions are: \code{vec2df.id}, \code{vec2df.hist}, and \code{vec2df.rank}. Defaults to \code{vec2df.id}.}

\item{...}{Additional arguments passed to \code{\link{multiFit}}).}
}
\value{
[list.multiFit] A list of results returned by the fitting function (cf. \code{\link{multiFit}}).
}
\description{
Apply \code{\link{multiFit}} to all rows or all columns of a table.
}
\examples{
dataset <- summary (sampleSoundCorrsData.abc)
models <- list (
	"model A" = list (
		formula = "Y ~ a/X",
		start = list (list(a=1))),
	"model B" = list (
		formula = "Y ~ a/(1+exp(1)^X)",
		start = list (list(a=1)))
)
fitTable (models, dataset, 1, vec2df.rank)
}
