% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{lapplyTest}
\alias{lapplyTest}
\title{Apply a function to a list.}
\usage{
lapplyTest(x, fun = chisq.test, ...)
}
\arguments{
\item{x}{[list] The list to which to apply \code{fun}.}

\item{fun}{[function] The function which to apply to \code{data}. Must return an object containing an element named \code{p.value}. Defaults to \code{\link{chisq.test}}.}

\item{...}{Additional arguments passed to \code{fun}.}
}
\value{
[list.lapplyTest] A list of outputs of \code{fun}.
}
\description{
Takes a list and applies to each of its elements a function, returning a list of outputs. Primary intended for tests of independence on a list of contingency tables.
}
\examples{
dataset <- sampleSoundCorrsData.abc
lapplyTest (allTables(dataset))
lapplyTest (allTables(dataset), fisher.test, simulate.p.value=TRUE)
}
