% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{tableTwo}
\alias{tableTwo}
\title{Build a contingency table counting either occurrences or words.}
\usage{
tableTwo(rows, cols, unit)
}
\arguments{
\item{rows}{[list] The list that will become rows, divided into words.}

\item{cols}{[list] The list that will become cols, divided into words.}

\item{unit}{[character] Count occurrences or words? Accepted values are \code{"o(cc(urence(s))))"} and \code{"w(or(d(s)))"}.}
}
\value{
[table] The contingency table.
}
\description{
Make a table out of two lists.
}
\examples{
dataset <- sampleSoundCorrsData.abc
soundcorrs:::tableTwo (dataset$segms[[1]]$z, dataset$segms[[2]]$z, "o")
}
\keyword{internal}
