% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortable-package.R
\docType{package}
\name{sortable}
\alias{sortable}
\alias{_PACKAGE}
\alias{sortable-package}
\title{sortable: Drag-and-Drop in 'shiny' Apps with 'SortableJS'}
\description{
Enables drag-and-drop behaviour in Shiny apps, by exposing the 
    functionality of the 'SortableJS' <https://sortablejs.github.io/Sortable/> 
    JavaScript library as an 'htmlwidget' <http://htmlwidgets.org>. 
    You can use this in Shiny apps and widgets, 'learnr' tutorials as well as 
    R Markdown. In addition, provides a custom 'learnr' question type - 
    'question_rank()' - that allows ranking questions with drag-and-drop.
}
\section{A new html widget}{

\itemize{
\item \code{\link[=sortable_js]{sortable_js()}} is a low-level function that adds the \code{SortableJS} to your widgets.
}
}

\section{Important functions}{


The important functions in this package are:
\itemize{
\item \code{\link[=rank_list]{rank_list()}} creates a drag-and-drop, rank list
\item \code{\link[=bucket_list]{bucket_list()}} lets you add multiple \code{rank_list} objects in columns
}
}

\section{Custom question types for \code{learnr}}{


You can also use new question types in your \code{learnr} tutorials:
\itemize{
\item \code{\link[=question_rank]{question_rank()}}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/rstudio/sortable}
  \item Report bugs at \url{https://github.com/rstudio/sortable/issues}
}

}
\author{
\strong{Maintainer}: Andrie de Vries \email{apdevries@gmail.com}

Authors:
\itemize{
  \item Barret Schloerke \email{barret@rstudio.com}
  \item Kenton Russell \email{kent.russell@timelyportfolio.com} (Original author) [conceptor]
}

Other contributors:
\itemize{
  \item Lebedev Konstantin ('SortableJS', http://sortablejs.github.io/Sortable/) [copyright holder]
}

}
\keyword{internal}
