% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beatComplexity.R
\name{beatComplexity}
\alias{beatComplexity}
\title{Beat spectrum complexity}
\usage{
beatComplexity(wave, plot = FALSE)
}
\arguments{
\item{wave}{A Wave object}

\item{plot}{If TRUE a spectrogram overlaid with the peaks is plotted.}
}
\value{
A list of the complexity, a vector of the peak periods, and the number of peaks.
}
\description{
This function computes a \code{beatSpectrum} and calculates some basic
measurements of its complexity. The complexity value is calculated as the
maximum identified repeating period (in seconds) divided by the number of
peaks.
}
\examples{
\dontrun{
  beatComplexity(sheep)
  beatComplexity(sheep, plot=TRUE)
}
}
