% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimalSOM.R
\name{optimalSOM}
\alias{optimalSOM}
\title{Estimate Optimal SOM Grid Size}
\usage{
optimalSOM(data, method = "A", increments, iterations)
}
\arguments{
\item{data}{The preprocessed data matrix containing the input data for SOM training.}

\item{method}{A character string indicating the method for estimating the maximum grid dimension. Options are:
\describe{
  \item{"A"}{Uses the heuristic formula by Vesanto et al. (default).}
  \item{"B"}{Applies an alternative heuristic approach.}
  \item{numeric}{Manually specified maximum dimension.}
}}

\item{increments}{An integer specifying the step size for increasing grid dimensions. For example, set increments to 2 or 5 to increment the grid size by 2 or 5 rows/columns at each step. Smaller increments lead to more granular searches but may increase computation time; larger increments risk errors if they exceed the estimated maximum SOM grid dimensions.}

\item{iterations}{An integer defining the number of iterations for SOM training. A lower value, such as less than 500, helps reduce computation time. If the process takes too long or an error occurs, try reducing the number of iterations for quicker results.}
}
\value{
A data frame summarizing quality measures and their associated optimal grid dimensions. Use these results to select the most suitable grid size for your SOM.
}
\description{
Computes the optimal grid size for training a SOM using various quality
measures and heuristic approaches.
}
\examples{
# Create a toy matrix with 9 columns and 100 rows
data <- matrix(rnorm(900), ncol = 9, nrow = 100)  # 900 random numbers, 100 rows, 9 columns

# Run the optimalSOM function with the mock data
myOptimalSOM <- optimalSOM(data, method = "A", increments = 2, iterations = 300)
}
