% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{solr_connect}
\alias{solr_connect}
\alias{solr_settings}
\title{Solr connection}
\usage{
solr_connect(url = "http://localhost:8983", proxy = NULL,
  errors = "simple", verbose = TRUE)

solr_settings()
}
\arguments{
\item{url}{Base URL for Solr instance. For a local instance, this is likely going
to be \code{http://localhost:8983} (also the default), or a different port if you
set a different port.}

\item{proxy}{List of arguments for a proxy connection, including one or more of:
url, port, username, password, and auth. See \code{\link[httr]{use_proxy}} for 
help, which is used to construct the proxy connection.}

\item{errors}{(character) One of simple or complete. Simple gives http code and 
error message on an error, while complete gives both http code and error message, 
and stack trace, if available.}

\item{verbose}{(logical) Whether to print help messages or not. E.g., if 
\code{TRUE}, we print the URL on each request to a Solr server for your 
reference. Default: \code{TRUE}}
}
\description{
Set Solr options, including base URL, proxy, and errors
}
\details{
This function sets environment variables that we use internally
within functions in this package to determine the right thing to do given your
inputs. 

In addition, \code{solr_connect} does a quick \code{GET} request to the URL you 
provide to make sure the service is up.
}
\examples{
\dontrun{
# set solr settings
solr_connect()

# set solr settings with a proxy
prox <- list(url = "187.62.207.130", port = 3128)
solr_connect(url = "http://localhost:8983", proxy = prox)

# get solr settings
solr_settings()

# you can also check your settings via Sys.getenv()
Sys.getenv("SOLR_URL")
Sys.getenv("SOLR_ERRORS")
}
}

