% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtraterrestrialNormal.R
\name{ExtraterrestrialNormal}
\alias{ExtraterrestrialNormal}
\title{Normal Extraterrestrial Solar Radiation}
\usage{
ExtraterrestrialNormal(DOY, Lat, Lon, SLon, DS, Slope, Aspect)
}
\arguments{
\item{DOY}{Day of year}

\item{Lat}{Latitude (in degrees)}

\item{Lon}{Longitude in degrees}

\item{SLon}{Standard longitude (based on time zone) in degrees}

\item{DS}{Daylight saving in minutes}

\item{Slope}{Site slope in degrees}

\item{Aspect}{Site aspect with respect to the south in degrees}
}
\description{
This function calculates extraterrestrial solar radiation normal to surface (in W/m2) for a given day of year, location and topogrpahy.
}
\examples{

#Calculating solar incidence angle for two consecutive days on 45 degree latitude and
# 10 degree longitude

DOY <- seq(0, 2, .05)

SextrNormal <- ExtraterrestrialNormal(DOY, Lat = 45, Lon=10, SLon=10, DS=0, Slope = 10, Aspect = 0)
#Note: only the difference between Lon and SLon matters not each value

plot(DOY, SextrNormal)

}
\keyword{Extraterrestrial}
\keyword{Normal}
\keyword{Radiation}
\keyword{Solar}
