% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolationForest_r6.R
\name{isolationForest}
\alias{isolationForest}
\title{Fit an Isolation Forest}
\description{
'solitude' class implements the isolation forest method
  introduced by paper Isolation based Anomaly Detection (Liu, Ting and Zhou
  <doi:10.1145/2133360.2133363>). The extremely randomized trees (extratrees)
  required to build the isolation forest is grown using
  \code{\link[ranger]{ranger}} function from \pkg{ranger} package.
}
\section{Design}{
 \code{$new()} initiates a new 'solitude' object. The
  possible arguments are:

  \itemize{

  \item \code{sample_size}: (positive integer, default = 256) Number of
  observations in the dataset to used to build a tree in  the forest

  \item \code{num_trees}: (positive integer, default = 100) Number of trees
  to be built in the forest

  \item \code{replace}: (boolean, default = FALSE) Whether the sample of
  observations should be chosen with replacement when sample_size is less
  than the number of observations in the dataset

  \item \code{seed}: (positive integer, default = 101) Random seed for the
  forest

  \item \code{nproc}: (NULL or a positive integer, default: NULL, means use
  all resources) Number of parallel threads to be used by ranger

  \item \code{respect_unordered_factors}: (string, default: "partition")See
  respect.unordered.factors argument in \code{\link[ranger]{ranger}}

  }

  \code{$fit()} fits a isolation forest for the given dataframe, computes
  depths of terminal nodes of each tree and stores the anomaly scores and
  average depth values in \code{$scores} object as a data.table

  \code{$predict()} returns anomaly scores for a new data as a data.table
}

\section{Details}{


  \itemize{

  \item Parallelization: \code{\link[ranger]{ranger}} is parallelized and by
  default uses all the resources. This is supported when nproc is set to
  NULL. The process of obtaining depths of terminal nodes (which is excuted
  with \code{$fit()} is called) may be parallelized separately by setting up
  a \pkg{future} backend.

  }
}

\examples{
data("humus", package = "mvoutlier")
columns_required = setdiff(colnames(humus)
                           , c("Cond", "ID", "XCOO", "YCOO", "LOI")
                           )
humus2 = humus[ , columns_required]
str(humus2)
set.seed(1)
index = sample(ceiling(nrow(humus2) * 0.5))
# initiate an isolation forest
iso = isolationForest$new(sample_size = length(index))
iso$fit(dataset = humus2[index, ])
iso$predict(humus2[index, ]) # scores for train data
iso$predict(humus2[-index, ]) # scores for new data (50\% sample)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{isolationForest$new()}}
\item \href{#method-fit}{\code{isolationForest$fit()}}
\item \href{#method-predict}{\code{isolationForest$predict()}}
\item \href{#method-clone}{\code{isolationForest$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{isolationForest$new(
  sample_size = 256,
  num_trees = 100,
  replace = FALSE,
  seed = 101,
  nproc = NULL,
  respect_unordered_factors = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{isolationForest$fit(dataset)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{isolationForest$predict(data)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{isolationForest$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
