% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchSCAN.R
\name{fetchSCAN}
\alias{fetchSCAN}
\alias{SCAN_sensor_metadata}
\alias{SCAN_site_metadata}
\title{Get data from USDA-NRCS SCAN (Soil Climate Analysis Network) Stations}
\usage{
fetchSCAN(site.code, year, report = "SCAN", req = NULL)
}
\arguments{
\item{site.code}{a vector of site codes}

\item{year}{a vector of years}

\item{report}{report name, single value only}

\item{req}{list of SCAN request parameters, for backwards-compatibility only}
}
\value{
a \code{data.frame} object; \code{NULL} on bad request.
}
\description{
Query soil/climate data from USDA-NRCS SCAN Stations
}
\details{
See \href{http://ncss-tech.github.io/AQP/soilDB/fetchSCAN-demo.html}{the fetchSCAN tutorial for details}. These functions require the \code{httr} and \code{rvest} libraries.
}
\examples{

\donttest{
if(requireNamespace("curl") &
    curl::has_internet()) {

    # get data: new interface
    x <- fetchSCAN(site.code=c(356, 2072), year=c(2015, 2016))
    str(x)

    # get sensor metadata
    m <- SCAN_sensor_metadata(site.code=c(356, 2072))

    # get site metadata
    m <- SCAN_site_metadata(site.code=c(356, 2072))
}
}

}
\references{
https://www.wcc.nrcs.usda.gov/index.html
}
\author{
D.E. Beaudette
}
\keyword{manip}
