% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_site_data_from_NASIS_db.R
\name{get_site_data_from_NASIS_db}
\alias{get_site_data_from_NASIS_db}
\title{Get Site Data from a local NASIS Database}
\usage{
get_site_data_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = default.stringsAsFactors(),
  dsn = NULL
)
}
\arguments{
\item{SS}{fetch data from Selected Set in NASIS or from the entire local
database (default: \code{TRUE})}

\item{stringsAsFactors}{logical: should character vectors be converted to
factors? This argument is passed to the \code{uncode()} function. It does not
convert those vectors that have been set outside of \code{uncode()} (i.e. hard
coded).}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}
}
\value{
A data.frame
}
\description{
Get site-level data from a local NASIS database.
}
\details{
When multiple "site bedrock" entries are present, only the shallowest is
returned by this function.
}
\seealso{
\code{\link{get_hz_data_from_NASIS_db}}
}
\author{
Jay M. Skovlin and Dylan E. Beaudette
}
\keyword{manip}
