% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_info.r
\name{db_info}
\alias{db_info}
\title{List database info.}
\usage{
db_info(cushion, dbname, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{Cushion} object. Required.}

\item{dbname}{Database name}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to one of the HTTP verbs (e.g,.
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, \code{\link[httr]{PUT}},
etc.)}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
List database info.
}
\examples{
\dontrun{
(x <- Cushion$new())

if ("sofadb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="sofadb"))
}
db_create(x, dbname='sofadb')

db_info(x, dbname="sofadb")
db_info(x, dbname="sofadb", as='json')
}
}

