% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{generateNextPartition}
\alias{generateNextPartition}
\title{Next partition}
\usage{
generateNextPartition(gen)
}
\arguments{
\item{gen}{A generator object.}
}
\value{
A generator function.
If the generator is already down to its last partition, it will throw an error.
}
\description{
Skip to the next partition of the generator.
}
\examples{
coalitions <- createPowerset(c('a','b'), includeEmptySet = FALSE)
# list(c('a','b'), 'a', 'b')

gen <- powerRelationGenerator(coalitions)
gen()
# (ab ~ a ~ b)

gen()
# (ab ~ b) > a

# skipping partition of size two, where the first partition has
# 2 coalitions and the second partition has 1 coalition
gen <- generateNextPartition(gen)
gen()
# ab > (a ~ b)

# only remaining partition is one of size 3, wherein each
# equivalence class is of size 1
gen <- generateNextPartition(gen)
gen()
# ab > a > b

# went through all partitions, it will only generate NULL now
gen <- generateNextPartition(gen)
stopifnot(is.null(gen()))

}
\seealso{
Other generator functions: 
\code{\link{powerRelationGenerator}()}
}
\concept{generator functions}
