% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexcel1.R
\name{L1Scores}
\alias{L1Scores}
\alias{L1Ranking}
\alias{lexcel1Scores}
\alias{lexcel1Ranking}
\title{L1 Ranking}
\usage{
L1Scores(powerRelation, elements = powerRelation$elements)

L1Ranking(powerRelation)

lexcel1Scores(powerRelation, elements = powerRelation$elements)

lexcel1Ranking(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{elements}{Vector of elements of which to calculate their scores.
By default, the scores of all elements in \code{powerRelation$elements} are considered.}
}
\value{
Score function returns a list of type \code{Lexcel1Scores} and length of \code{powerRelation$elements}
(unless parameter \code{elements} is specified).
Each index contains a vector of length \code{powerRelation$eqs}, the number of
times the given element appears in each equivalence class.

Ranking function returns corresponding \code{\link{SocialRanking}} object.
}
\description{
Calculate the \eqn{L^{(1)}}{L^(1)} scores.
}
\details{
Similar to \code{\link[=lexcelRanking]{lexcelRanking()}}, the number of times an element appears in each equivalence class is counted.
In addition, we now also consider the size of the coalitions.

Let \eqn{N}{N} be a set of elements, \eqn{\succeq \in \mathcal{T}(\mathcal{P})}{>= in T(P)} be a power relation,
and \eqn{\Sigma_1 \succ \Sigma_2 \succ \dots \succ \Sigma_m}{E_1 > E_2 > ... > E_m} its corresponding quotient order.

For an element \eqn{i \in N}{i in N}, we get a matrix \eqn{M^\succeq_i}{M^(>=)_i} with \eqn{m}{m} columns and \eqn{|N|}{|N|} rows.
Whereas each column represents an equivalence class, each row corresponds to the coalition size.

\deqn{(M^\succeq_i)_{pq} = |\{S \in \Sigma_q: |S| = p\}|}{(M^(>=)_i)_(pq) = |\{S in E_q: |S| = p\}}

Take as an example \eqn{\succeq: (123 \sim 13 \sim 2) \succ (12 \sim 1 \sim 3) \succ (23 \sim \{\})}{>=: (123 ~ 13 ~ 2) > (12 ~ 1 ~ 3) > (23 ~ \{\})}.
From this, we get the following three matrices:

\deqn{
M^\succeq_1 = \begin{bmatrix}
0 & 1 & 0\\
1 & 1 & 0\\
1 & 0 & 0
\end{bmatrix}
M^\succeq_2 = \begin{bmatrix}
1 & 0 & 0\\
0 & 1 & 1\\
1 & 0 & 0
\end{bmatrix}
M^\succeq_3 = \begin{bmatrix}
0 & 1 & 0\\
1 & 0 & 1\\
1 & 0 & 0
\end{bmatrix}
}{
M^(>=)_1 = matrix(c(0,1,1,1,1,0,0,0,0),nrow=3)\\
M^(>=)_2 = matrix(c(1,0,1,0,1,0,0,1,0),nrow=3)\\
M^(>=)_3 = matrix(c(0,1,1,1,0,0,0,1,0),nrow=3)
}

The \eqn{L^{(1)}}{L^(1)} then ranks the elements, rewarding elements that appear in higher ranking coalitions as well as smaller coalitions.
When comparing two matrices for a power relation, if \eqn{M^\succeq_i >_{L^{(1)}} M^\succeq_j}{M^(>=)_i > M^(>=)_j (the ^(>=) will be omitted to improve readability)},
this suggests that there exists a \eqn{p^0 \in \{1, \dots, |N|\}}{p^0 in \{1, ..., |N|\}} and \eqn{q^0 \in \{1, \dots, m\}}{q^0 in \{1, ..., m\}} such that the following holds:
\enumerate{
\item \eqn{(M^\succeq_i)_{p^0q^0} > (M^\succeq_j)_{p^0q^0}}{(M_i)_(p^0 q^0) > (M_j)_(p^0 q^0)}
\item \eqn{(M^\succeq_i)_{pq^0} = (M^\succeq_j)_{pq^0}}{(M_i)_(p q^0) = (M_j)_(p q^0)} for all \eqn{p < p^0}{p < p^0}
\item \eqn{(M^\succeq_i)_{pq} = (M^\succeq_j)_{pq}}{(M_i)_(pq) = (M_j)_(pq)} for all \eqn{q < q^0}{q < q^0} and \eqn{p \in \{1, \dots, |N|\}}{p in \{1, ..., |N|\}}
}

In the aforementioned example, we have that \eqn{M^\succeq_2 >_{L^{(1)}} M^\succeq_1 >_{L^{(1)}} M^\succeq_3}{M_2 > M_1 > M_3}, suggesting that element 2 should be ranked highest and 3 lowest.
}
\section{Aliases}{


For better discoverability, \code{lexcel1Scores()} and \code{lexcel1Ranking()} serve as aliases for \code{L1Scores()} and \code{L1Ranking()}, respectively.
}

\examples{
pr <- as.PowerRelation("(123 ~ 13 ~ 2) > (12 ~ 1 ~ 3) > (23 ~ {})")
scores <- L1Scores(pr)
scores$`1`
#      [,1] [,2] [,3]
# [1,]    0    1    0
# [2,]    1    1    0
# [3,]    1    0    0

L1Ranking(pr)
# 2 > 1 > 3

}
\references{
\insertRef{2021Lexcel}{socialranking}
}
\seealso{
Other ranking solution functions: 
\code{\link{copelandScores}()},
\code{\link{cumulativeScores}()},
\code{\link{kramerSimpsonScores}()},
\code{\link{lexcelScores}()},
\code{\link{ordinalBanzhafScores}()}
}
\concept{ranking solution functions}
