% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerRelation.R
\name{equivalenceClassIndex}
\alias{equivalenceClassIndex}
\title{Get index of equivalence class containing a coalition}
\usage{
equivalenceClassIndex(powerRelation, coalition, stopIfNotExists = TRUE)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}

\item{coalition}{a coalition vector or \code{\link[sets:set]{sets::set}} that is part of \code{powerRelation}}

\item{stopIfNotExists}{\code{TRUE} if an error should be thrown when the coalition given is not in the \code{PowerRelation} object.
If \code{FALSE}, \code{-1} will be returned}
}
\value{
Numeric value, equivalence class index where \code{coalition} appears in.
}
\description{
Given a \code{coalition} \link[base:c]{vector} or \code{\link[sets:set]{sets::set()}},
return the index of the equivalence class it is located in.
}
\examples{
pr <- newPowerRelation(c(1,2), ">", c(1), "~", c(2))

# 1
equivalenceClassIndex(pr, c(1, 2))

# 2
equivalenceClassIndex(pr, c(1))

# 2
equivalenceClassIndex(pr, c(2))

# Error: The coalition {} does not appear in the power relation
tryCatch(
  equivalenceClassIndex(pr, c()),
  error = function(e) { e }
)

# Error: This time only return a -1
stopifnot(-1 == equivalenceClassIndex(pr, c(), stopIfNotExists = FALSE))

}
