% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankingBoilerplate.R
\name{doRanking}
\alias{doRanking}
\title{Create \code{SocialRankingSolution}}
\usage{
doRanking(
  powerRelation,
  scores,
  isIndifferent = function(a, b) a == b,
  decreasing = TRUE
)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}

\item{scores}{A sortable vector or list of element scores}

\item{isIndifferent}{A function that returns \code{TRUE}, if given two elements from \code{scores} the order doesn't matter.
In that case the two elements are indifferent from each other, symbolized with the \code{"~"} operator.}

\item{decreasing}{If \code{TRUE} (default), elements with the higher scores are ranked higher.}
}
\value{
A list of type \code{SocialRankingSolution}.
Each element of the list contains a \code{\link[sets:set]{sets::set()}} of elements in \code{powerRelation} that are indifferent to one another.
}
\description{
Map a power relation between coalitions to a power relation between elements, also known as a social ranking solution.
}
\examples{
pr <- newPowerRelationFromString("2 > 12 > 1", asWhat = as.numeric)

# we define our own social ranking solution.
# a player's score is determined by the equivalence class index it first appears in.
# lower is better
scores <- c(`1` = 2, `2` = 1)

# 2 > 1
doRanking(
  pr,
  scores,
  isIndifferent = function(x, y) x == y,
  decreasing = FALSE
)

# Suppose for a player to be ranked higher than the other,
# their positions have to be at least 2 apart.
# This means player 1 and 2 are indifferent,
# if they are right next to each other in the power relation.
# 2 ~ 1
doRanking(
  pr,
  scores,
  isIndifferent = function(x, y) abs(x - y) < 2,
  decreasing = FALSE
)

}
