% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_label.r
\name{add.to.label}
\alias{add.to.label}
\title{Add values to label}
\usage{
add.to.label(object, value = "freq", prefix = "default", suffix = ")",
  dim = 1)
}
\arguments{
\item{object}{is a soc.ca object}

\item{value}{the type of values added to the labels. "freq" adds
frequencies, "mass" adds mass values to the active modalities, "ctr" adds contribution values to the active modalities, "cor" adds correlation values.
value also accepts any vector with the length of the number of active
modalities. "linebreak" adds a linebreak \code{\\n} after the first ":" in the label.}

\item{prefix}{if "default" an appropriate prefix is used}

\item{suffix}{the suffix}

\item{dim}{the dimension from which values are retrieved}
}
\value{
a soc.ca object with altered labels in names.mod and names.sup
}
\description{
Adds values to the end of the label of each modality.
}
\examples{
example(soc.ca)
result.label  <- add.to.label(result)
result.label$names.mod
result.label  <- add.to.label(result, value = "ctr", dim = 2)
result.label$names.mod
result.label  <- add.to.label(result, value = result$variable, prefix = " - ", suffix = "")
result.label$names.mod
result.label  <- add.to.label(result, value = "linebreak")
result.label$names.mod
map.ctr(result.label)
}

