% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_reest}
\alias{plot_reest}
\alias{plot_reest.glmsmurf}
\title{Plot Coefficients of Re-estimated Model}
\usage{
plot_reest(x, ...)

\method{plot_reest}{glmsmurf}(x, xlab = "Index",
  ylab = "Re-estimated coefficients", basic = FALSE, ...)
}
\arguments{
\item{x}{An object for which the extraction of model coefficients is meaningful. 
E.g. an object of class '\code{\link[=glmsmurf-class]{glmsmurf}}', typically the result of a call to \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}}.}

\item{...}{Additional arguments for the \code{\link[graphics]{plot}} function.}

\item{xlab}{Label for the x-axis, default is \code{"Index"}.}

\item{ylab}{Label for the y-axis, default is \code{"Re-estimated coefficients"}.}

\item{basic}{Logical indicating if the basic lay-out is used for the plot, default is \code{FALSE}.}
}
\description{
Function to plot the coefficients of the re-estimated model.
}
\details{
When the re-estimated model is not included in \code{x}, 
         the coefficients of the estimated model in \code{x} are plotted with a warning.
         
         See \code{\link{plot.glmsmurf}} for more details.
}
\examples{
## See example(glmsmurf) for examples
}
\seealso{
\code{\link{plot.glmsmurf}}, \code{\link{coef_reest}}, \code{\link{summary.glmsmurf}}, \code{\link{glmsmurf}}, \code{\link{glmsmurf-class}}
}
