% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.R
\name{discrete}
\alias{discrete}
\title{Univariate Discrete Distributions: p.m.f and c.d.f.}
\usage{
discrete(
  distn,
  var_support = NULL,
  params = list(),
  param_step = list(),
  param_range = list(),
  p_vec = NULL,
  smallest = 0.01,
  plot_par = list(),
  panel_plot = TRUE,
  hscale = NA,
  vscale = hscale,
  observed_value = NA,
  ...
)
}
\arguments{
\item{distn}{Either a character string or a function to choose the discrete
  random variable.

  Strings \code{"binomial"}, \code{"geometric"},
  \code{"hypergeometric"}, \code{"negative binomial"} and \code{"poisson"}
  are recognised, case being ignored.  The relevant distributional functions
  \code{dxxx} and \code{pxxx} in the \code{\link[stats]{stats-package}}
  are used.  The abbreviations \code{xxx} are also recognised.
  If \code{distn = "hypergeometric"} then the \code{(size, prob)}
  parameterisation is used, unless a value for \code{mu} is provided
  via the argument \code{params} when the \code{(size, mu)}
  parameterisation is used.

  Valid functions are set up like a standard distributional function
  \code{dxxx}, with first argument \code{x}, last argument \code{log}
  and with arguments to set the parameters of the distribution in between.
  See the \href{https://CRAN.R-project.org/view=Distributions}{
  CRAN task view on distributions}.
  It is assumed that the support of the random variable is a
  subset of the integers, unless \code{var_support} is set to the contrary.

  If \code{distn} is not supplied then \code{distn = "binomial"}
  is used.}

\item{var_support}{A numeric vector.  Can be used to set a fixed set of
values for which to plot the p.m.f. and c.d.f., in order better
to see the effects of changing the parameter values or to set a support
that isn't a subset of the integers.
If \code{var_support} is set then it overrides \code{p_vec} (see below).}

\item{params}{A named list of initial parameter values with which to start
  the movie.  If \code{distn} is a string and a particular parameter value
  is not supplied then the following values are used.
  \code{"binomial"}: \code{size = 10, prob = 0.5};
  \code{"geometric"}: \code{prob = 0.5};
  \code{"hypergeometric"}: \code{m = 10, n = 7, k = 8};
  \code{"negative binomial"}: \code{size = 10, prob = 0.5};
  \code{"poisson"}: \code{lambda = 5}.

  If \code{distn} is a function then \code{params} must set any required
  parameters.

  If parameter value is outside the corresponding range specified by
  \code{param_range} then it is set to the closest limit of the range.}

\item{param_step}{A named list of the amounts by which the respective
parameters in \code{params} are increased/decreased after one click of
the +/- button. If \code{distn} is a function then the default is 0.1
for all parameters.  If \code{distn} is a string then a sensible
distribution-specific default is set internally.}

\item{param_range}{A named list of the ranges over which the respective
parameters in \code{params} are allowed to vary.  Each element of the list
should be a vector of length 2: the first element gives the lower limit
of the range, the second element the upper limit.
Use \code{NA} to impose no limit.
If \code{distn} is a function then all parameters are unconstrained.}

\item{p_vec}{A numeric vector of length 2.  The p.d.f. and c.d.f. are
plotted between the 100\code{p_vec[1]}\% and 100\code{p_vec[2]}\%
quantiles of the distribution.  If \code{p_vec} is not supplied then
a sensible distribution-specific default is used.  If \code{distn} is
a function then the default is \code{p_vec = c(0.001, 0.999)}.}

\item{smallest}{A positive numeric scalar.  The smallest value to be
used for any strictly positive parameters when \code{distn} is a string.}

\item{plot_par}{A named list of graphical parameters
(see \code{link[graphics]{par}}) to be passed to
\code{\link[graphics]{plot}}.  This may be used to alter the appearance
of the plots of the p.m.f. and c.d.f.}

\item{panel_plot}{A logical parameter that determines whether the plot
is placed inside the panel (\code{TRUE}) or in the standard graphics
window (\code{FALSE}).  If the plot is to be placed inside the panel
then the tkrplot library is required.}

\item{hscale, vscale}{Numeric scalars.  Scaling parameters for the size
of the plot when \code{panel_plot = TRUE}. The default values are 1.4 on
Unix platforms and 2 on Windows platforms.}

\item{observed_value}{A non-negative integer.  If \code{observed_value} is
supplied then the corresponding line in the plot of the p.m.f. is coloured
in red.}

\item{...}{Additional arguments to be passed to
\code{\link[rpanel]{rp.doublebutton}}, not including \code{panel},
\code{variable}, \code{title}, \code{step}, \code{action}, \code{initval},
\code{range}.}
}
\value{
Nothing is returned, only the animation is produced.
}
\description{
A movie to illustrate how the probability mass function (p.m.f.) and
cumulative distribution function (c.d.f.) of a discrete random variable
depend on the values of its parameters.
}
\details{
The movie starts with a plot of the p.m.f. of the distribution
  for the initial values of the parameters.  Buttons
  increase (+) or decrease (-) each parameter.  There are radio buttons
  to switch the plot from the p.m.f. to the c.d.f. and back.

  Owing to a conflict with the argument \code{size} of the function
  \code{\link[rpanel]{rp.control}} the parameter \code{size} of,
  for example, the binomial and negative binomial distributions, is
  labelled as \code{n}.
}
\examples{
# Binomial example
discrete()

# The same example, but using a user-supplied function and setting manually
# the initial parameters, parameter step size and range
discrete(distn = dbinom, params = list(size = 10, prob = 0.5),
         param_step = list(size = 1),
         param_range = list(size = c(1, NA), prob = c(0, 1)))

# Poisson distribution. Show the use of var_support
discrete(distn = "poisson", var_support = 0:20)
}
\seealso{
\code{\link{movies}}: a user-friendly menu panel.

\code{\link{smovie}}: general information about smovie.
}
