% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{prsLasso}
\alias{prsLasso}
\title{Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the Lasso for polygenic risk scores (prs).}
\usage{
prsLasso(X, y, s, lambda)
}
\arguments{
\item{X}{The design matrix.}

\item{y}{The response vector.}

\item{s}{The shrinkage parameter used to regularize the design matrix.}

\item{lambda}{The regularization parameter of the prs Lasso.}
}
\value{
A list with six functions, precisely the objective \eqn{u}, penalty \eqn{v}, and dependence structure \eqn{w}, as well as their derivatives \eqn{du}, \eqn{dv}, and \eqn{dw}.
}
\description{
Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the Lasso for polygenic risk scores (prs).
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
betavector <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% betavector
s <- 0.5
lambda <- 1
temp <- prsLasso(X,y,s,lambda)

}
\references{
Mak, T.S., Porsch, R.M., Choi, S.W., Zhou, X., and Sham, P.C. (2017). Polygenic scores via penalized regression on summary statistics. Genet Epidemiol, 41(6):469-480.

Mak, T.S. and Porsch, R.M. (2020). lassosum: LASSO with summary statistics and a reference panel. R package version 0.4.5.

Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.
}
