% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{solveSmoothedLASSOSequence}
\alias{solveSmoothedLASSOSequence}
\title{Minimize the smoothed LASSO objective function with respect to \eqn{\beta} using the progressive smoothing algorithm.}
\usage{
solveSmoothedLASSOSequence(X, y, lambda, muSeq = 2^seq(3, -6), entropy = T)
}
\arguments{
\item{X}{The data matrix of dimensions \eqn{n \times p}.}

\item{y}{The \eqn{n}-vector of responses.}

\item{lambda}{The LASSO regularization parameter.}

\item{muSeq}{The sequence of Nesterov smoothing parameters. The default is \eqn{2^{-n}} for \eqn{n \in \{0,\ldots,5\}}.}

\item{entropy}{A boolean switch to select the entropy prox function (default) or the squared error prox function.}
}
\value{
The LASSO estimator \eqn{\beta}.
}
\description{
Minimize the smoothed LASSO objective function with respect to \eqn{\beta} using the progressive smoothing algorithm.
}
\examples{
library(smoothedLasso)
require(Matrix)
n <- 100
p <- 500
beta <- runif(p)
X <- Matrix(sample(0:1,size=n*p,replace=TRUE),nrow=n,ncol=p,sparse=TRUE)
y <- X \%*\% beta
lambda <- 1
print(solveSmoothedLASSOSequence(X,y,lambda))

}
