% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{objFunctionSmoothGradient}
\alias{objFunctionSmoothGradient}
\title{Auxiliary function which computes the gradient of the smoothed LASSO objective function with respect to \eqn{\beta}.}
\usage{
objFunctionSmoothGradient(beta, X, y, lambda, mu, entropy = T)
}
\arguments{
\item{beta}{The \eqn{p}-vector of coefficients.}

\item{X}{The data matrix of dimensions \eqn{n \times p}.}

\item{y}{The \eqn{n}-vector of responses.}

\item{lambda}{The LASSO regularization parameter.}

\item{mu}{The Nesterov smoothing parameter.}

\item{entropy}{A boolean switch to select the entropy prox function (default) or the squared error prox function.}
}
\value{
The value of the gradient of the LASSO objective function at \eqn{\beta}.
}
\description{
Auxiliary function which computes the gradient of the smoothed LASSO objective function with respect to \eqn{\beta}.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
beta <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% beta
lambda <- 1
print(objFunctionSmoothGradient(beta,X,y,lambda,mu=0.1))

}
