% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem.lm.R
\name{semLm}
\alias{semLm}
\title{Linear Regression with Interval Censored Dependent Variable}
\usage{
semLm(formula, data, classes, burnin = 40, samples = 200, trafo = "None",
  adjust = 2, bootstrap.se = FALSE, b = 100)
}
\arguments{
\item{formula}{an object of class \code{formula}, as in
\code{\link[stats]{lm}}. The
dependent variable is measured as interval censored values; factor with
ordered factor values}

\item{data}{a data frame containing the variables of the model}

\item{classes}{numeric vector of classes; \code{-Inf} as first and
\code{Inf} as last value
is allowed. If the Box-Cox or
logarithmic transformation is chosen, the minimum interval bound must be
\eqn{\ge 0}.}

\item{burnin}{the number of burn-in iterations of the SEM-algorithm}

\item{samples}{the number of additional iterations of the SEM-algorithm
for parameter estimation}

\item{trafo}{transformation of the dependent variable to fulfill the model
assumptions
  \itemize{
  \item "log" for Logarithmic transformation
  \item "bc" for Box-Cox transformation
}
default is \code{"None"}. Transformations can only be used if the minimum
interval bound is \eqn{\ge 0}.}

\item{adjust}{extends the number of iteration steps of the SEM-algorithm
for finding the optimal lambda of the Box-Cox transformation. The number of
iterations
is extended in the following way: \code{(burnin+samples)*adjust}}

\item{bootstrap.se}{if \code{TRUE} standard errors for the regression
parameters
 are estimated}

\item{b}{number of bootstrap iterations for the estimation of the standard
errors}
}
\value{
An object of class "sem" that provides parameter estimates for linear
regression models with interval censored dependent variable. Generic
functions such as, \code{\link{print}},
\code{\link{plot}}, and \code{\link{summary}} have methods that can be used
to obtain further information.  See \code{\link{semObject}} for a description
of the components
of objects of class "sem".
}
\description{
This function estimates the linear regression model when the
dependent
variable is interval censored. The estimation of the standard errors is
fasciliated
by a non-parametric bootstrap.
}
\details{
The model parameters are estimated using pseudo samples as a proxy
 for the
interval censored dependent variable. The object \code{pseudo.y} returns the
pseudo samples of each iteration step of the SEM-algorithm.
}
\examples{
\donttest{
# Load and prepare data
data <- Exam
classes <- c(1,1.5,2.5,3.5,4.5,5.5,6.5,7.7,8.5, Inf)
data$examsc.class<- cut(data$examsc, classes)

# Run model with default settings
model <- semLm(formula = examsc.class ~ standLRT + schavg, data = data,
classes = classes)
summary(model)
} \dontshow{
# Load and prepare data
data <- Exam
classes <- c(1,1.5,2.5,3.5,4.5,5.5,6.5,7.7,8.5, Inf)
data$examsc.class<- cut(data$examsc, classes)

# Run model with default settings
model <- semLm(formula = examsc.class ~ standLRT + schavg, data = data,
classes = classes, burnin = 4, samples = 10)
summary(model)
}
}
\references{
Walter, P., Gross, M., Schmid, T. and Tzavidis, N. (2017). Estimation of
Linear and Non-Linear Indicators
using Interval Censored Income Data. FU-Berlin School of Business & Economics,
Discussion
Paper.
}
\seealso{
\code{\link[stats]{lm}}, \code{\link{print.sem}},
\code{\link{plot.sem}}, \code{\link{summary.sem}}
}
