#' Binary adjacency matrix for \code{neast}
#'
#' A binary adjacency matrix for the \code{neast} data set.
#' Some of the islands (e.g., Nantucket) are considered
#' adjacent to the mainland because of ferries traveling
#' from certain mainland regions to these islands. Manual
#' connections were added for many of the New York counties
#' because they are on islands.
#'
#' @name neastw
#' @docType data
#' @references Martin Kulldorff, Eric J. Feuer, Barry A.
#'   Miller, Laurence S. Freedman; Breast Cancer Clusters in
#'   the Northeast United States: A Geographic Analysis,
#'   American Journal of Epidemiology, Volume 146, Issue 2,
#'   15 July 1997, Pages 161–170.
#'   \doi{10.1093/oxfordjournals.aje.a009247}.
#'
#' @keywords data
#' @seealso neast
NULL
