% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn2zones.R
\name{nn2zones}
\alias{nn2zones}
\title{Convert nearest neighbors list to zones}
\usage{
nn2zones(nn)
}
\arguments{
\item{nn}{A list of nearest neighbors}
}
\value{
A list of zones
}
\description{
\code{nn2zones} converts a list of nearest neighbors to
a list of zones.  The list of nearest neighbors will
come from functions such as \code{\link{nnpop}} or
\code{knn}.
}
\examples{
data(nydf)
coords = with(nydf, cbind(x, y))
nn = knn(coords, k = 2)
nn2zones(nn)
}
