% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bn.test.R
\name{bn.test}
\alias{bn.test}
\title{Besag-Newell Test}
\usage{
bn.test(
  coords,
  cases,
  pop,
  cstar,
  ex = sum(cases)/sum(pop) * pop,
  alpha = 0.1,
  longlat = FALSE,
  modified = FALSE
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{cstar}{A non-negative integer indicating the
minimum number of cases to include in each window.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{modified}{A logical value indicating whether a
modified version of the test should be performed.  The
original paper recommends computing the p-value for
each cluster as \code{1 - ppois(cstar - 1, lambda =
expected)}. The modified version replaces \code{cstar}
with \code{cases}, the observed number of cases in the
region, and computes the p-value for the cluster as
\code{1 - ppois(cases - 1, lambda = ex)}. The default
is \code{modified = FALSE}.}
}
\value{
Returns a \code{smerc_cluster} object.
}
\description{
\code{bn.test} implements the Besag-Newell test of Besag
and Newell (1991) for finding disease clusters.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(x, y))
out = bn.test(coords = coords, cases = nydf$cases,
              pop = nydf$pop, cstar = 6,
              alpha = 0.1)
plot(out)

data(nypoly)
library(sp)
plot(nypoly, col = color.clusters(out))
}
\references{
Besag, J. and Newell, J.  (1991). The
  detection of clusters in rare diseases, Journal of the
  Royal Statistical Society, Series A, 154, 327-333.
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.test}}
}
\author{
Joshua French
}
