% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex.sim.R
\name{flex.sim}
\alias{flex.sim}
\title{Perform \code{flex.test} on simualated data}
\usage{
flex.sim(nsim = 1, zones, ty, ex, type = "poisson", ein = NULL,
  eout = NULL, tpop = NULL, popin = NULL, popout = NULL,
  cl = NULL)
}
\arguments{
\item{nsim}{A positive integer indicating the number of
simulations to perform.}

\item{zones}{A list of zones to compute the test statistic
over for each simulated data set.}

\item{ty}{The total number of cases in the study area.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{type}{The type of scan statistic to implement. The
default is \code{"poisson"}, with the other choice
being \code{"binomial"}.}

\item{ein}{The expected number of cases in the zone.
Conventionally, this is the estimated overall disease
risk across the study area, multiplied by the total
population size of the zone.}

\item{eout}{The expected number of cases outside the
zone.  This should be \code{ty - ein} and is computed
automatically if not provided.}

\item{tpop}{The total population in the study area.}

\item{popin}{The total population in the zone.}

\item{popout}{The population outside the zone.  This
should be \code{tpop - popin} and is computed
automatically if not provided.}

\item{cl}{
A cluster object created by \code{\link[parallel]{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}
}
\value{
A vector with the maximum test statistic for each
  simulated data set.
}
\description{
\code{flex.sim} efficiently performs
\code{\link{flex.test}} on a simulated data set.  The
function is meant to be used internally by the
\code{\link{flex.test}} function, but is informative for
better understanding the implementation of the test.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(longitude, latitude))
zones = flex.zones(coords, w = nyw, k = 3, longlat = TRUE)
cases = floor(nydf$cases)
ty = sum(cases)
ex = ty/sum(nydf$pop) * nydf$pop
ein = zones.sum(zones, ex)
tsim = flex.sim(nsim = 2, zones, ty, ex, ein = ein, eout = ty - ein)
}
