% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlf.test.R
\name{mlf.test}
\alias{mlf.test}
\title{Maxima Likelihood First Scan Test}
\usage{
mlf.test(coords, cases, pop, w, ex = sum(cases)/sum(pop) * pop, nsim = 499,
  alpha = 0.1, nreport = nsim + 1, ubpop = 0.5, ubd = 0.5,
  lonlat = FALSE, parallel = TRUE)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid coordinates for the regions.}

\item{cases}{The number of cases in each region.}

\item{pop}{The population size of each region.}

\item{w}{The binary spatial adjacency matrix.}

\item{ex}{The expected number of cases for each region.  The default is calculated under the constant risk hypothesis.}

\item{nsim}{The number of simulations from which to compute p-value.}

\item{alpha}{The significance level to determine whether a cluster is signficant.  Default is 0.05.}

\item{nreport}{The frequency with which to report simulation progress.  The default is \code{nsim+ 1}, meaning no progress will be displayed.}

\item{ubpop}{The upperbound of the proportion of the total population to consider for a cluster.}

\item{ubd}{The upperbound for the proportion of the maximum intercentroid distance to allow for the maximum size of a zone.}

\item{lonlat}{If lonlat is TRUE, then the great circle distance is used to calculate the intercentroid distance.  The default is FALSE, which specifies that Euclidean distance should be used.}

\item{parallel}{A logical indicating whether the test should be parallelized using the \code{parallel::mclapply function}.  Default is TRUE.  If TRUE, no progress will be reported.}
}
\value{
Returns a list of length two of class scan. The first element (clusters) is a list containing the significant, non-ovlappering clusters, and has the the following components: 
\item{locids}{The location ids of regions in a significant cluster.}
\item{pop}{The total population in the cluser window.}
\item{cases}{The observed number of cases in the cluster window.}
\item{expected}{The expected number of cases in the cluster window.}
\item{smr}{Standarized mortaility ratio (observed/expected) in the cluster window.}
\item{rr}{Relative risk in the cluster window.}
\item{loglikrat}{The loglikelihood ratio for the cluster window (i.e., the log of the test statistic).}
\item{pvalue}{The pvalue of the test statistic associated with the cluster window.}
\item{w}{The adjacency matrix of the cluster.}
\item{r}{The maximum radius of the cluster (in terms of intercentroid distance from the starting region).}
The second element of the list is the centroid coordinates.  This is needed for plotting purposes.
}
\description{
\code{mlf.test} implements the Maxima Likelihood First scan test of Yao et al. (2011), which is actually a special case of the Dynamic Minimum Spanning Tree of Assuncao et al. (2006).  Find the single region that maximizes the likelihood ratio test statistic.  Starting with this single region as a current zone, new candidate zones are constructed by combining the current zone with the connected region that maximizes the likelihood ratio test static.  This procedure is repeated until the population upper bound is reached.
}
\details{
Only a single cluster is ever returned because the algorithm only constructs a single sequence of starting zones, and overlapping zones are not returned.  Only the zone that maximizes the likelihood ratio test statistic is returned.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(longitude, latitude))
out = mlf.test(coords = coords, cases = floor(nydf$cases), 
                  pop = nydf$pop, w = nyw, 
                  alpha = 0.12, lonlat = TRUE,
                  nsim = 10, ubpop = 0.1, ubd = 0.5)
data(nypoly)
library(sp)
plot(nypoly, col = color.clusters(out))
}
\references{
Yao, Z., Tang, J., & Zhan, F. B. (2011). Detection of arbitrarily-shaped clusters using a neighbor-expanding approach: A case study on murine typhus in South Texas. International journal of health geographics, 10(1), 1.

Assuncao, R.M., Costa, M.A., Tavares, A. and Neto, S.J.F. (2006). Fast detection of arbitrarily shaped disease clusters, Statistics in Medicine, 25, 723-742.
}
\author{
Joshua French
}
