% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmst.test.R
\name{dmst.test}
\alias{dmst.test}
\title{Dynamic minimum spanning tree scan test}
\usage{
dmst.test(coords, cases, pop, w, ex = sum(cases)/sum(pop) * pop, nsim = 499,
  alpha = 0.1, nreport = nsim + 1, ubpop = 0.5, ubd = 0.5,
  lonlat = FALSE, parallel = TRUE)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid coordinates for the regions.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each region.}

\item{w}{A binary spatial adjacency matrix.}

\item{ex}{The expected number of cases for each region.  The default is calculated under the constant risk hypothesis.}

\item{nsim}{The number of simulations from which to compute the p-value.}

\item{alpha}{The significance level to determine whether a cluster is signficant.  Default is \code{0.10}.}

\item{nreport}{The frequency with which to report simulation progress.  The default is \code{nsim+ 1}, meaning no progress will be displayed.}

\item{ubpop}{The upperbound of the proportion of the total population to consider for a cluster.}

\item{ubd}{The upperbound for the radius of a cluster.  This should be a proportion in (0, 1].  The value is the proportion of the maximum intercentroid distance between any two locations in \code{coords}. See Details.}

\item{lonlat}{The default is \code{FALSE}, which specifies that Euclidean distance should be used.If \code{lonlat} is \code{TRUE}, then the great circle distance is used to calculate the intercentroid distance.}

\item{parallel}{A logical indicating whether the test should be parallelized using the \code{parallel::mclapply function}.  Default is \code{TRUE}.  If \code{TRUE}, no progress will be reported.}
}
\value{
Returns a list of length two of class scan. The first element (clusters) is a list containing the significant, non-ovlappering clusters, and has the the following components: 
\item{locids}{The location ids of regions in a significant cluster.}
\item{pop}{The total population in the cluser window.}
\item{cases}{The observed number of cases in the cluster window.}
\item{expected}{The expected number of cases in the cluster window.}
\item{smr}{Standarized mortaility ratio (observed/expected) in the cluster window.}
\item{rr}{Relative risk in the cluster window.}
\item{loglikrat}{The loglikelihood ratio for the cluster window (i.e., the log of the test statistic).}
\item{pvalue}{The pvalue of the test statistic associated with the cluster window.}
The second element of the list is the centroid coordinates.  This is needed for plotting purposes.
}
\description{
\code{dmst.test} implements the Dynamic Minimum Spanning Tree scan test of Assuncao et al. (2006).  Starting with a single region as a current zone, new candidate zones are constructed by combining the current zone with the connected region that maximizes the resulting likelihood ratio test statistic.  This is procedure repeated until the population or distance upper bound are reached.  The same procedure is repeated for each region.  The maxima likelihood first scan test proposed by Yao et al. (2011) is an independent variant of this, but only searches from the starting region that maximizes the likelihood ratio scan statistic. The clusters returned are non-overlapping, ordered from most significant to least significant.  The first cluster is the most likely to be a cluster.  If no significant clusters are found, then the most likely cluster is returned (along with a warning).
}
\details{
The maximum intercentroid distance can be found by executing the command: \code{sp::spDists(as.matrix(coords), longlat = lonlat)}, based on the specified values of \code{coords} and \code{lonlat}.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(longitude, latitude))
\dontrun{
out = dmst.test(coords = coords, cases = floor(nydf$cases), 
                pop = nydf$pop, w = nyw, 
                alpha = 0.12, lonlat = TRUE,
                nsim = 5, ubpop = 0.1, ubd = 0.2)
data(nypoly)
library(sp)
plot(nypoly, col = color.clusters(out))}

}
\references{
Assuncao, R.M., Costa, M.A., Tavares, A. and Neto, S.J.F. (2006). Fast detection of arbitrarily shaped disease clusters, Statistics in Medicine, 25, 723-742.

Yao, Z., Tang, J., & Zhan, F. B. (2011). Detection of arbitrarily-shaped clusters using a neighbor-expanding approach: A case study on murine typhus in South Texas. International journal of health geographics, 10(1), 1.
}
\seealso{
\code{\link{scan.stat}}, \code{\link{plot.scan}}, 
\code{\link{scan.test}}, \code{\link{flex.test}}, 
\code{\link{uls.test}}, \code{\link{bn.test}}
}
\author{
Joshua French
}
