% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scan.stat.R
\name{scan.stat}
\alias{scan.stat}
\title{Scan Statistic}
\usage{
scan.stat(yin, ein, yout, eout, type = "poisson")
}
\arguments{
\item{yin}{The sum of the response values inside the window.  Generally, the sum of the cases.}

\item{ein}{The expected value of the response in the window.  Generally, the estimated overall risk for all regions combined, multiplied by the population size of the window.}

\item{yout}{The sum of the response values outside the window.}

\item{eout}{The expected value of the response outside the window.}

\item{type}{The type of scan statistic to implement.  Currently, only "poisson" is implemented.}
}
\value{
A vector of scan statistics.
}
\description{
\code{scan.stat} calculates a scan statistic for various distributions.
}
\examples{
# statistic for most likely cluster of New York leukemia data
scan.stat(106, 62.13, 552 - 106, 552 - 62.13)
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.  Kulldorff, M. (1997) A spatial scan statistic. Communications in Statistics -- Theory and Methods 26, 1481-1496.
}

