% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smcfcs_parallel.r
\name{smcfcs.parallel}
\alias{smcfcs.parallel}
\title{Parallel substantive model compatible imputation}
\usage{
smcfcs.parallel(
  smcfcs_func = "smcfcs",
  seed,
  m = 5,
  n_cores = parallel::detectCores() - 1,
  cl_type = "PSOCK",
  outfile = "",
  ...
)
}
\arguments{
\item{smcfcs_func}{Specifies which base smcfcs function to call. Possible values
are `smcfcs`, `smcfcs.casecohort`, `smcfcs.dtasam`, `smcfcs.nestedcc`. Defaults
to `smcfcs`.}

\item{seed}{A required seed, set as `set.seed` when `n_cores = 1`,
or as `parallel::clusterSetRNGStream` when `n_cores > 1`.}

\item{m}{Number of imputed datasets to generate.}

\item{n_cores}{Number of cores over which to split the `m` imputations. If
`n_cores` is not divisible exactly by `m`, one of the cores will perform
more/less imputations that the rest such that the final result still contains
`m` imputed datasets.}

\item{cl_type}{Either "PSOCK" or "FORK". If running on a Windows system
"PSOCK" is recommended, otherwise for Linux/Mac machines "FORK" tends to
offer faster computation - see \link[mice]{parlmice}.}

\item{outfile}{Optional character path to location for
output from the workers. Useful to diagnose rejection sampling warnings.
File path must be formulated as "path/to/filename.txt".}

\item{...}{Additional arguments to pass on to \link[smcfcs]{smcfcs},
\link[smcfcs]{smcfcs.casecohort},
\link[smcfcs]{smcfcs.dtsam}, or
\link[smcfcs]{smcfcs.nestedcc}.}
}
\value{
An object of type "smcfcs", as would usually be returned from
\link[smcfcs]{smcfcs}.
}
\description{
Runs substantive model compatible imputation using parallel cores
}
\details{
This function can be used to call one of the substantive model compatible imputation
methods using parallel cores, to reduce computation time. You must specify
the arguments required for the standard smcfcs call, and then specify your
the arguments for how to use parallel cores.
}
\examples{
\dontrun{
# Detect number of cores
parallel::detectCores()

imps <- smcfcs.parallel(
smcfcs_func="smcfcs",
seed = 2021,
n_cores = 2,
originaldata = smcfcs::ex_compet,
m = 10,
smtype = "compet",
smformula = list(
"Surv(t, d == 1) ~ x1 + x2",
"Surv(t, d == 2) ~ x1 + x2"
),
method = c("", "", "norm", "norm")
)
}
}
\author{
Edouard F. Bonneville \email{e.f.bonneville@lumc.nl}

Jonathan Bartlett \email{j.w.bartlett@bath.ac.uk}
}
