% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_smap.R
\name{download_smap}
\alias{download_smap}
\title{Download SMAP data}
\usage{
download_smap(files, directory = NULL, overwrite = TRUE)
}
\arguments{
\item{files}{A \code{data.frame} produced by \code{find_smap()}
that specifies data files to download.}

\item{directory}{A local directory path in which to save data, specified as a
character string. If left as \code{NULL}, data are stored in a user's cache
directory.}

\item{overwrite}{TRUE or FALSE: should existing data files be overwritten?}
}
\value{
Returns a \code{data.frame} that appends a column called
\code{local_dir} to the input data frame, which consists of a character
vector specifying the local directory containing the downloaded files.
}
\description{
This function downloads SMAP data in HDF5 format.
}
\details{
This function requires a username and password from NASA's Earthdata portal.
If you have a username and password, pass them in as environment vars using:

\code{Sys.setenv(ed_un = '<your username>', ed_pw = '<your password>')}

If you do not yet have a username and password, register for one here:
\url{https://urs.earthdata.nasa.gov/}
}
\examples{
\dontrun{
files <- find_smap(id = "SPL4SMGP", dates = "2015-03-31", version = 3)
# files[1, ] refers to the first available data file
downloads <- download_smap(files[1, ])
}
}
