% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMovResHan.R
\name{fitMRH}
\alias{fitMRH}
\title{Fit a Moving-Resting-Handling Model with Embedded Brownian Motion}
\usage{
fitMRH(data, start, segment = NULL,
  numThreads = RcppParallel::defaultNumThreads() * 3/4, lower = c(0.001,
  0.001, 0.001, 0.001, 0.001), upper = c(10, 10, 10, 10, 0.999),
  integrControl = integr.control())
}
\arguments{
\item{data}{a data.frame whose first column is the observation time, and other
columns are location coordinates. If \code{segment} is not \code{NULL},
additional column with the same name given by \code{segment} should be
included. This additional column is used to indicate which part of
observations shoule be used to fit model. The value of this column can
be any integer with 0 means discarding this observation and non-0 means
using this obversvation. Using different non-zero numbers indicate different
segments. (See vignette for more details.)}

\item{start}{The initial value for optimization, in the order of rate
of moving, rate of resting, rate of handling, volatility and switching
probability.}

\item{segment}{character variable, name of the column which indicates segments,
in the given \code{data.frame}. The default value, \code{NULL}, means using
whole dataset to fit the model.}

\item{numThreads}{int, the number of threads allocated for parallel
computation. The default setup is 3/4 available threads. If this parameter
is less or equal to 1, the serial computation will be processed.}

\item{lower, upper}{Lower and upper bound for optimization.}

\item{integrControl}{Integration control vector includes rel.tol,
abs.tol, and subdivisions.}
}
\value{
A list of estimation result with following components:
\item{estimate}{the estimated parameter vector}
\item{loglik}{maximized loglikelihood or composite loglikelihood
evaluated at the estimate}
\item{convergence}{convergence code from \code{nloptr}}
}
\description{
Fit a Moving-Resting-Handling Model with Embedded Brownian Motion with
animal movement data at discretely observation times by maximizing
a full likelihood. Using \code{segment} to fit part of observations to
the model. A practical application of this feature is seasonal analysis.
}
\examples{
\donttest{
## slow work, may take several hours
set.seed(06269)
tgrid <- seq(0, 400, by = 8)
dat <- rMRH(tgrid, 4, 0.5, 0.1, 5, 0.8, 'm')
fitMRH(dat, c(4, 0.5, 0.1, 5, 0.8)) ## parallel process
fitMRH(dat, c(4, 0.5, 0.1, 5, 0.8), numThreads = -1) ## serial process

## fit part of dataset to the MRH model
batch <- c(rep(0, 10), rep(1, 7), rep(0, 10), rep(2, 10), rep(0, 14))
dat.segment <- cbind(dat, batch)
fit.segment <- fitMRH(dat.segment, start = c(4, 0.5, 0.1, 5, 0.8), segment = "batch")
head(dat.segment)
fit.segment
}

}
\references{
Pozdnyakov, V., Elbroch, L.M., Hu, C., Meyer, T., and Yan, J. (2018+)
On estimation for Brownian motion governed by telegraph process with
multiple off states. <arXiv:1806.00849>
}
\seealso{
\code{\link{rMRH}} for simulation.
}
\author{
Chaoran Hu
}
