% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdplus.test.R
\name{kdplus.test}
\alias{kdplus.test}
\title{Global test of clustering using difference in K functions}
\usage{
kdplus.test(x)
}
\arguments{
\item{x}{A \code{kdenv} object from the \code{kdest}
function.}
}
\value{
A list providing the observed test statistic
  (\code{kdplus}) and the estimate p-value
  {\code{pvalue}}.
}
\description{
\code{kdplus.test} performs a global test of clustering
for comparing cases and controls using the method of
Diggle and Chetwynd (1991).  It relies on the difference
in estimated K functions.
}
\examples{
data(grave)
# construct envelopes for differences in estimated K functions
kdenv = kdest(grave, nsim = 9)
kdplus.test(kdenv)
}
\references{
Waller, L.A. and Gotway, C.A. (2005).
  Applied Spatial Statistics for Public Health Data.
  Hoboken, NJ: Wiley.  
  
  Diggle, Peter J., and Amanda G.
  Chetwynd. "Second-order analysis of spatial clustering
  for inhomogeneous populations." Biometrics (1991):
  1155-1163.
}
\seealso{
\code{\link{kdest}}
}
\author{
Joshua French
}
