% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradient_color_scale.R
\name{gradient.color.scale}
\alias{gradient.color.scale}
\title{Create gradient color scale with midpoint}
\usage{
gradient.color.scale(
  minval,
  maxval,
  n = 11,
  low = "blue",
  mid = "white",
  high = "red",
  midpoint = 0,
  ...
)
}
\arguments{
\item{minval}{The minimum value of the data to be colored}

\item{maxval}{The maximum value of the data to be colored}

\item{n}{The desired number of breaks (approximately)}

\item{low}{The color for the low values}

\item{mid}{The color used for the midpoint of the gradient}

\item{high}{The color used for the high values}

\item{midpoint}{The midpoint of the color scale}

\item{...}{
  Arguments passed on to \code{\link[grDevices:colorRamp]{grDevices::colorRamp}}
  \describe{
    \item{\code{colors}}{colors to interpolate; must be a valid argument to
    \code{\link[grDevices]{col2rgb}()}.}
    \item{\code{bias}}{a positive number.  Higher values give more widely spaced
    colors at the high end.}
    \item{\code{space}}{a character string; interpolation in RGB or CIE Lab
    color spaces.}
    \item{\code{interpolate}}{use spline or linear interpolation.}
    \item{\code{alpha}}{logical: should alpha channel (opacity) values be
    returned?   It is an error to give a true value if
    \code{space} is specified.}
  }}
}
\value{
A list with \code{col} and \code{breaks} components specifying the colors and breaks of the color scale.
}
\description{
Create gradient color scale with midpoint
}
\examples{
data(grave)
lr = logrr(grave)
grad = gradient.color.scale(min(lr$v, na.rm = TRUE), max(lr$v, na.rm = TRUE))
plot(lr, col = grad$col, breaks = grad$breaks)
}
\references{
Based on code from https://stackoverflow.com/a/10986203/5931362
}
