% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kdest.R
\name{kdest}
\alias{kdest}
\title{Difference of estimated K functions}
\usage{
kdest(
  x,
  case = 2,
  nsim = 0,
  level = 0.95,
  r = NULL,
  rmax = NULL,
  breaks = NULL,
  correction = c("border", "isotropic", "Ripley", "translate"),
  nlarge = 3000,
  domain = NULL,
  var.approx = FALSE,
  ratio = FALSE
)
}
\arguments{
\item{x}{A \code{\link[spatstat.geom]{ppp}} object 
package with marks for the case and control groups.}

\item{case}{The position of the name of the "case" group 
in \code{levels(x$marks)}.  The default is 2. 
\code{x$marks} is assumed to be a factor.  Automatic 
conversion is attempted if it is not.}

\item{nsim}{An non-negative integer.  Default is 0.  The
difference in estimated K functions will be calculated
for \code{nsim} data sets generated under the random
labeling hypothesis.  These will be used to construct
the non-rejection envelopes.}

\item{level}{The level used for the non-rejection envelopes. 
Ignored if \code{nsim} is 0.}

\item{r}{
    Optional. Vector of values for the argument \eqn{r} at which \eqn{K(r)} 
    should be evaluated. Users are advised \emph{not} to specify this
    argument; there is a sensible default. If necessary, specify \code{rmax}.
  }

\item{rmax}{
    Optional. Maximum desired value of the argument \eqn{r}.
  }

\item{breaks}{
    This argument is for internal use only.
  }

\item{correction}{
    Optional. A character vector containing any selection of the
    options \code{"none"}, \code{"border"}, \code{"bord.modif"},
    \code{"isotropic"}, \code{"Ripley"}, \code{"translate"},
    \code{"translation"}, \code{"rigid"},
    \code{"none"}, \code{"good"} or \code{"best"}.
    It specifies the edge correction(s) to be applied.
    Alternatively \code{correction="all"} selects all options.
  }

\item{nlarge}{
    Optional. Efficiency threshold.
    If the number of points exceeds \code{nlarge}, then only the
    border correction will be computed (by default), using a fast algorithm.
  }

\item{domain}{Optional. Calculations will be restricted
to this subset of the window. See Details of
\code{\link[spatstat.core]{Kest}}.}

\item{var.approx}{Logical. If \code{TRUE}, the approximate
    variance of \eqn{\hat K(r)}{Kest(r)} under CSR
    will also be computed.
  }

\item{ratio}{
    Logical. 
    If \code{TRUE}, the numerator and denominator of
    each edge-corrected estimate will also be saved,
    for use in analysing replicated point patterns.
  }
}
\value{
Returns a \code{kdenv} object.  See documentation
  for \code{spatstat::Kest}.
}
\description{
\code{kdest} determines the difference in estimated K
functions for a set of cases and controls.  Non-rejection
envelopes can also be produced.
}
\details{
This function relies internally on the 
\code{\link[spatstat.core]{Kest}} and 
\code{\link[spatstat.core]{eval.fv}} functions from the 
\code{spatstat} package.  The arguments are essentially
the same as the \code{\link[spatstat.core]{Kest}} function, 
and the user is referred there for more details about
the various arguments.
}
\examples{
data(grave)
kd1 = kdest(grave)
plot(kd1, iso ~ r, ylab = "difference", legend = FALSE, main = "")
kd2 = kdest(grave, nsim = 9, level = 0.8)
plot(kd2)
}
\references{
Waller, L.A. and Gotway, C.A. (2005). 
  Applied Spatial Statistics for Public Health Data. 
  Hoboken, NJ: Wiley.
}
\seealso{
\code{\link[spatstat.core]{Kest}},
  \code{\link[spatstat.core]{eval.fv}}
}
\author{
Joshua French
}
